/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.efs;

import com.aptana.core.io.efs.FileTree;
import com.aptana.core.io.efs.WorkspaceFileSystem;
import com.aptana.core.io.vfs.IFileTreeVisitor;
import com.aptana.core.io.vfs.Policy;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.InfiniteProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkspaceFile
extends FileStore {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IResource resource;
    private final IPath path;
    private LocalFile localFileStore;

    private WorkspaceFile(IResource resource) {
        this(resource, resource.getFullPath());
    }

    protected WorkspaceFile(IPath path) {
        this(null, path);
    }

    private WorkspaceFile(IResource resource, IPath path) {
        this.resource = resource;
        this.path = path;
    }

    public Object getAdapter(Class adapter) {
        if (IResource.class.equals((Object)adapter)) {
            try {
                this.ensureResource();
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
            }
            return this.resource;
        }
        return super.getAdapter(adapter);
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureResource();
        if (this.resource instanceof IContainer) {
            IContainer container = (IContainer)this.resource;
            if (!container.isSynchronized(1)) {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            final ArrayList childNames = new ArrayList();
            final boolean[] skipSelf = new boolean[]{true};
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (skipSelf[0]) {
                        skipSelf[0] = false;
                        return true;
                    }
                    childNames.add(proxy.getName());
                    return false;
                }
            }, 8);
            return childNames.toArray(new String[childNames.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            FileInfo fileInfo = (FileInfo)this.localFileStore.fetchInfo(options, monitor);
            if (this.path.isRoot()) {
                fileInfo.setName(this.path.toPortableString());
            }
            return fileInfo;
        }
        FileInfo info = new FileInfo(this.path.lastSegment());
        info.setExists(false);
        return info;
    }

    public IFileStore getChild(String name) {
        return new WorkspaceFile(this.path.append(name));
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IFileStore getParent() {
        if (this.path.equals((Object)Path.ROOT)) {
            return null;
        }
        return new WorkspaceFile(this.path.removeLastSegments(1));
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureResource();
        if (this.resource instanceof IFile) {
            return ((IFile)this.resource).getContents(true);
        }
        org.eclipse.core.internal.filesystem.Policy.error((int)271, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path), (Throwable)new FileNotFoundException(this.path.toPortableString()));
        return null;
    }

    public URI toURI() {
        try {
            return new URI("workspace", null, this.path.toPortableString(), null);
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.ensureResource();
        if (this.resource != null && destination instanceof WorkspaceFile) {
            this.resource.copy(((WorkspaceFile)destination).path, 33, monitor);
        } else {
            super.copy(destination, options, monitor);
        }
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureResource();
        if (this.resource != null) {
            this.resource.delete(3, monitor);
        }
    }

    public IFileStore getFileStore(IPath path) {
        return new WorkspaceFile(this.path.append(path));
    }

    public IFileSystem getFileSystem() {
        return WorkspaceFileSystem.getInstance();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkspaceFile)) {
            return false;
        }
        return this.path.equals((Object)((WorkspaceFile)((Object)obj)).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore(IFolder.class);
        if (this.resource != null && !this.resource.exists()) {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(MessageFormat.format("Creating folder {0}", this.path.lastSegment()), 100);
            try {
                if ((options & 4) == 0) {
                    WorkspaceFile.createParentsRecursive(this.resource, Policy.subMonitorFor(monitor, 80));
                } else {
                    Policy.subMonitorFor(monitor, 80).done();
                }
                ((IFolder)this.resource).create(1, true, Policy.subMonitorFor(monitor, 20));
            }
            catch (CoreException e) {
                WorkspaceFile.fileNotFoundError(e, this.path);
            }
        }
        return this;
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (!(destination instanceof WorkspaceFile)) {
            this.ensureResource();
            if (this.resource != null && this.resource.exists()) {
                super.move(destination, options, monitor);
                return;
            }
            org.eclipse.core.internal.filesystem.Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path), (Throwable)new FileNotFoundException(this.path.toPortableString()));
        }
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(NLS.bind((String)Messages.moving, (Object)destination.toString()), 100);
        WorkspaceFile destinationFile = (WorkspaceFile)destination;
        try {
            boolean overwrite;
            Object destinationResource;
            this.ensureResource();
            if (this.resource == null) {
                org.eclipse.core.internal.filesystem.Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path), (Throwable)new FileNotFoundException(this.path.toPortableString()));
            }
            if ((destinationResource = destinationFile.ensureResource()) == null) {
                destinationResource = this.resource instanceof IContainer ? workspaceRoot.getFolder(destinationFile.path) : workspaceRoot.getFile(destinationFile.path);
            }
            boolean sourceEqualsDest = this.resource.equals(destinationResource);
            boolean bl = overwrite = (options & 2) != 0;
            if (!sourceEqualsDest && !overwrite && destinationResource.exists()) {
                org.eclipse.core.internal.filesystem.Policy.error((int)268, (String)NLS.bind((String)Messages.fileExists, (Object)destinationResource.getFullPath()), (Throwable)new FileNotFoundException(destinationFile.path.toPortableString()));
            }
            try {
                if (destinationResource.exists()) {
                    destinationResource.delete(1, Policy.subMonitorFor(monitor, 20));
                }
            }
            catch (CoreException e) {
                org.eclipse.core.internal.filesystem.Policy.error((int)273, (String)NLS.bind((String)Messages.couldnotDelete, (Object)this.toString(), (Object)destination.toString()), (Throwable)new FileNotFoundException(destinationFile.path.toPortableString()));
            }
            if (!destinationResource.getParent().exists()) {
                org.eclipse.core.internal.filesystem.Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.toString(), (Object)destination.toString()), (Throwable)new FileNotFoundException(destinationFile.path.toPortableString()));
            }
            try {
                this.resource.move(destinationResource.getFullPath(), true, Policy.subMonitorFor(monitor, 80));
            }
            catch (CoreException e) {
                org.eclipse.core.internal.filesystem.Policy.error((int)272, (String)NLS.bind((String)Messages.failedMove, (Object)this.toString(), (Object)destination.toString()), (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            this.localFileStore.putInfo(info, options, monitor);
        } else {
            org.eclipse.core.internal.filesystem.Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path));
        }
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            return this.localFileStore.toLocalFile(options, monitor);
        }
        return null;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore(IFile.class);
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask("", 100);
        if (this.localFileStore == null) {
            try {
                ((IFile)this.resource).create((InputStream)new ByteArrayInputStream(EMPTY_ARRAY), 1, Policy.subMonitorFor(monitor, 50));
            }
            catch (CoreException e) {
                WorkspaceFile.fileNotFoundError(e, this.path);
            }
            this.ensureLocalFileStore();
        }
        if (this.localFileStore != null) {
            return this.localFileStore.openOutputStream(options, Policy.subMonitorFor(monitor, 50));
        }
        return null;
    }

    public String toString() {
        return this.path.toString();
    }

    private IResource ensureResource() throws CoreException {
        return this.ensureResource(null);
    }

    private IResource ensureResource(Class<? extends IResource> resourceClass) throws CoreException {
        if (!(this.resource == null || this.resource.isSynchronized(0) && this.resource.exists())) {
            this.resource = null;
            this.localFileStore = null;
        }
        if (this.resource == null) {
            IWorkspaceRoot container = workspaceRoot;
            if (this.path.segmentCount() > 2) {
                container = workspaceRoot.getFolder(this.path.removeLastSegments(1));
            } else if (this.path.segmentCount() == 2) {
                container = workspaceRoot.getProject(this.path.segment(0));
            }
            this.resource = this.path.isRoot() ? workspaceRoot : container.findMember(this.path.lastSegment());
            if (this.resource == null) {
                if (IFile.class.equals(resourceClass)) {
                    this.resource = workspaceRoot.getFile(this.path);
                } else if (IFolder.class.equals(resourceClass)) {
                    this.resource = workspaceRoot.getFolder(this.path);
                }
            }
            if (resourceClass != null && !resourceClass.isInstance(this.resource)) {
                this.resource = null;
                org.eclipse.core.internal.filesystem.Policy.error((int)276, (String)NLS.bind((String)Messages.failedCreateWrongType, (Object)this.path));
            }
        }
        return this.resource;
    }

    private LocalFile ensureLocalFileStore() throws CoreException {
        return this.ensureLocalFileStore(null);
    }

    private LocalFile ensureLocalFileStore(Class<? extends IResource> resourceClass) throws CoreException {
        this.ensureResource(resourceClass);
        if (this.localFileStore == null && this.resource != null && this.resource.exists() && this.resource.getLocation() != null) {
            this.localFileStore = new LocalFile(this.resource.getLocation().toFile());
        }
        return this.localFileStore;
    }

    private static void createParentsRecursive(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null) {
            return;
        }
        IContainer parent = resource.getParent();
        if (parent.exists()) {
            return;
        }
        monitor.beginTask("", 100);
        WorkspaceFile.createParentsRecursive((IResource)parent, Policy.subMonitorFor(monitor, 80));
        if (parent instanceof IFolder) {
            ((IFolder)parent).create(1, true, Policy.subMonitorFor(monitor, 20));
        }
    }

    private static void fileNotFoundError(CoreException cause, IPath path) throws CoreException {
        IStatus status = cause.getStatus();
        throw new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), (Throwable)new FileNotFoundException(path.toPortableString())));
    }

    public static IFileStore fromLocalFile(File file) {
        IContainer resource = null;
        if (file.isDirectory()) {
            resource = workspaceRoot.getContainerForLocation(Path.fromOSString((String)file.getAbsolutePath()));
        } else if (file.isFile()) {
            resource = workspaceRoot.getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
        }
        if (resource != null) {
            return new WorkspaceFile((IResource)resource);
        }
        return null;
    }

    public IFileTree fetchFileTree(IFileTreeVisitor visitor, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            FileTree fileTree = new FileTree((IFileStore)this);
            WorkspaceFile.buildFileTree(fileTree, this, visitor, (IProgressMonitor)new InfiniteProgressMonitor(monitor));
            FileTree fileTree2 = fileTree;
            return fileTree2;
        }
        finally {
            monitor.done();
        }
    }

    private static void buildFileTree(FileTree fileTree, WorkspaceFile parent, IFileTreeVisitor visitor, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(MessageFormat.format("Listing directory {0}", parent.path), 20);
        IFileInfo[] infos = parent.childInfos(0, monitor);
        ArrayList<IFileStore> stores = new ArrayList<IFileStore>();
        ArrayList<IFileStore> dirs = new ArrayList<IFileStore>();
        IFileInfo[] iFileInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo fileInfo = iFileInfoArray[n2];
            IFileStore store = parent.getChild(fileInfo.getName());
            if (visitor == null || visitor.include(store)) {
                stores.add(store);
                if (fileInfo.isDirectory()) {
                    dirs.add(store);
                }
            }
            ++n2;
        }
        fileTree.addChildren((IFileStore)parent, stores.toArray(new IFileStore[stores.size()]), infos);
        monitor.worked(1);
        for (IFileStore store : dirs) {
            WorkspaceFile.buildFileTree(fileTree, (WorkspaceFile)store, visitor, monitor);
        }
    }
}

